-- try to port old plugin content to current version

-- 
global pxJoint -- old joint helper

-- load the old d6 script if the old plugin is not installed
if pxJoint == undefined then
(
	filein "px_d6joint.ms"
)

fn PxNeedSolveCompatibility =
(
	local hadOld = false
	if PHYSX_AUTODESK_VER==undefined do
	(
		if px_plugin_version == 1 then 
		(
			for i in objects do
			(
				type = PxGetNodeUserProp i "PhysicsType" PX_PHYSTYPE_UNDEFINED
				-- if it is using RB modifier or RagdollHelper, it is new plugin
				if PxIsRB(i) or (classof(n) == RagdollHelper) then
				(
					-- mark new version tag
					px_plugin_version = px_current_version
					hadOld = false
				)
				else if (type == PX_PHYSTYPE_DYNAMIC) or (type == PX_PHYSTYPE_KINEMATIC) or (type == PX_PHYSTYPE_STATIC) then 
				(
					if not PxIsRB(i) then hadOld = true
				)
				else if classof(i) == pxJoint then  
				(
					hadOld =true
				)
			)
		)
	)
	hadOld
)

fn PxIsBuildInShape n  =
(
	type = classof(n)
	(type == Sphere) or (type == Box) or (type == Capsule)
)

fn PxConvertOldRB n =
(
	type = PxGetNodeUserProp n "PhysicsType" PX_PHYSTYPE_UNDEFINED
	if type == PX_PHYSTYPE_UNDEFINED then  false
	else
	(
		modRB = PhysXModRB()
		modRB.type = type
		-- parse hull
		v = getuserprop n "Proxy_Geometry"
		if v != undefined then
		(
			h = findobject v
			format " hull is %\n" h
			if h != undefined then
			(
				modRB.meshType = PX_MESHTYPE_CUSTOM
				h.parent = n
				--modRB.physicalMesh = h
				modRB.customMesh = h
			)
		)
		if modRB.meshType != PX_MESHTYPE_CUSTOM then
		(
			if PxIsBuildInShape(n) then 
				modRB.meshType = PX_MESHTYPE_ORIGINAL
			else if type == PX_PHYSTYPE_DYNAMIC then
				modRB.meshType = PX_MESHTYPE_CONVEX
			else if type == PX_PHYSTYPE_KINEMATIC then
				modRB.meshType = PX_MESHTYPE_CONVEX
			else -- static
				modRB.meshType = PX_MESHTYPE_ORIGINAL
				
			--PxCreateRBPhysicalMesh(n)
		)
		--
		modRB.volume = nvpx.CalcVolume(n)
		
		v = getuserprop n "Density"
		if v != undefined then 
		(
			modRB.Density = v        --update density is enough
		)
		else
		(
			v = getuserprop n "Mass"
			if v != undefined then 
			(
				modRB.mass = v
			)
			else
			(
				-- set as default density value; it makes mass also right.
				modRB.Density = 0.5
			)
		)
		
		v = getuserprop n "Friction"
		if v != undefined then 
		(
			modRB.dynamicFriction = v
		)

		v = getuserprop n "StaticFriction"
		if v != undefined then 
		(
			modRB.staticFriction = v
		)
		
		v = getuserprop n "Restitution"
		if v != undefined then 
		(
			modRB.bounciness = v
		)

		v = getuserprop n "PutToSleep"
		if v != undefined then 
		(
			modRB.SleepAtStart = v
		)

		v = getuserprop n "InitialVelocityX"
		if v != undefined then 
		(
			modRB.InitialVelocityX = v
		)

		v = getuserprop n "InitialVelocityY"
		if v != undefined then 
		(
			modRB.InitialVelocityY = v
		)

		v = getuserprop n "InitialVelocityZ"
		if v != undefined then 
		(
			modRB.InitialVelocityZ = v
		)

		v = getuserprop n "InitialSpinX"
		if v != undefined then 
		(
			modRB.InitialSpinX = v * RATE_RAD_TO_DEGREE
		)

		v = getuserprop n "InitialSpinY"
		if v != undefined then 
		(
			modRB.InitialSpinY = v * RATE_RAD_TO_DEGREE
		)

		v = getuserprop n "InitialSpinZ"
		if v != undefined then 
		(
			modRB.InitialSpinZ = v * RATE_RAD_TO_DEGREE
		)

		--
		if isgrouphead(n) then
		(
			children = #()
			pxSelectionTool.GetAllGroupChildren n children
			for i in children do addmodifier i modRB
		)
		else
		(
			addmodifier n modRB
		)
	)
)

fn PxConvertOldJoint n =
(
	newJoint = nvConstraint()
	newJoint.Init()
	tm = n.transform
	tm.row4 = n.center
	if (n.aptype == 2) and (n.body0 != undefined) then
	(
		tm.row4 = n.body0.center
	)
	else if (n.aptype == 3) and (n.body1 != undefined) then
	(
		tm.row4 = n.body1.center
	)
	newJoint.transform = tm
		
	newJoint.body0 = n.body0
	newJoint.body1 = n.body1
	
	if newJoint.body0 != undefined then newJoint.parent = newJoint.body0
	
	newJoint.breakable = n.breakable
	newJoint.maxForce = n.maxForce
	newJoint.maxTorque = n.maxTorque
	
	newJoint.gearing = n.gearing
	newJoint.gearRatio = n.gearRatio
	
	newJoint.collision = n.collision
	
	newJoint.helpersize = n.helpersize
	
	newJoint.projectionMode = n.projectionMode
	newJoint.projectionDist = n.projectionDist
	newJoint.projectionAngle = n.projectionAngle * RATE_RAD_TO_DEGREE

	if (n.swing2_locked) then
		newJoint.swing1Mode = 1
	else if (not n.swing2_locked) and (not n.swing2_limited) then
		newJoint.swing1Mode = 3
	else 
		newJoint.swing1Mode = 2
	newJoint.swing1Angle = n.swing2_angle
	newJoint.swing1Restitution = n.swing2_rest
	newJoint.swing1Spring = n.swing2_spring
	newJoint.swing1Damping = n.swing2_spring
	
	if (n.swing1_locked) then
		newJoint.swing2Mode = PX_DOF_LOCKED
	else if (not n.swing1_locked) and (not n.swing1_limited) then
		newJoint.swing2Mode = PX_DOF_FREE
	else 
		newJoint.swing2Mode = PX_DOF_LIMITED
	newJoint.swing2Angle = n.swing1_angle
	newJoint.swing2Restitution = n.swing1_rest
	newJoint.swing2Spring = n.swing1_spring
	newJoint.swing2Damping = n.swing1_spring

	if (not n.twist_enbl) then
		newJoint.twistMode = PX_DOF_LOCKED
	else if (not n.twist_lmt) and (n.twist_enbl) then
		newJoint.twistMode = PX_DOF_FREE
	else
		newJoint.twistMode = PX_DOF_LIMITED
	newJoint.twistAngleLow = n.twistlow
	newJoint.twistAngleHigh = n.twisthigh
	newJoint.twistRestitutionLow = n.twist_rest
	newJoint.twistRestitutionHigh = newJoint.twistRestitutionLow  -- there is no such a param in old plugin
	newJoint.twistSpringLow = n.twist_spring
	newJoint.twistSpringHigh = newJoint.twistSpringLow   -- there is no such a param in old plugin
	newJoint.twistDampingLow = n.twist_damp
	newJoint.twistDampingHigh = newJoint.twistDampingLow   -- there is no such a param in old plugin
	
	newJoint.linearModeX = n.x_state
	newJoint.linearModeY = n.y_state
	newJoint.linearModeZ = n.z_state
	newJoint.linearPosition = n.xlate_rad
)

fn PxSolveCompatibilityIssues =
(
	if PxNeedSolveCompatibility() then 
	(
		info = nvpxText.compatibilitySolveConvertOld
		yes  = queryBox info
		if yes then
		(
			px_version_converting = true
			
			-- begin to vert
			nodesToDelete = #()
			for i in objects do
			(
				type = PxGetNodeUserProp i "PhysicsType" PX_PHYSTYPE_UNDEFINED
				case type of
				(
				PX_PHYSTYPE_DYNAMIC:   ( PxConvertOldRB(i); )
				PX_PHYSTYPE_KINEMATIC: ( PxConvertOldRB(i); )
				PX_PHYSTYPE_STATIC:    ( PxConvertOldRB(i); )
				default:
					if classof(i) == pxJoint then
					(
						PxConvertOldJoint i
						append nodesToDelete i
					)
				)
			)
			
			for i in nodesToDelete do delete i

			-- mark new version tag
			px_plugin_version = px_current_version
			
			-- version conversion is done
			px_version_converting = false
			messagebox nvpxText.compatibilitySolveWarning
		)
	)
)

fn PxDeleteBrokenRBs =
(
	for i in objects do
	(
		if nvpx.RBBroken(i) then 
		(
			format "Note: RB modifier of '%' is broken. Delete it.\n" i.name
			modRB = PxGetModRB i
			deletemodifier i modRB
		)
	)
)